function PrintResults(Data,Results,model)

Y=Results.Y;
m=size(Data.Dat,2);
if ~isempty(Y)
    p = size(Y{1},2);
else
    p=0;
end
fprintf('Results for model type %1i\n',model)
fprintf('Deviance value is %8.3f\n',Results.Deviance)
fprintf('Overview of parameter estimates\n')
for j=1:m
    fprintf('\nVariable %i: %s\nMain Effect',j,Data.Varlabels{j})
    if any(Data.V(:,j)) || any(Data.V(j,:))
        for k=1:p
            fprintf(['    Dim ' num2str(k)])
        end
    end
    fprintf('\n')
    for cat=1:max(Data.Dat(:,j))
        fprintf('%8.3f    ',Results.MainEffects{j}(cat));
        if any(Data.V(:,j)) || any(Data.V(j,:))
            for k=1:p
                fprintf('%8.3f ',Results.Y{j}(cat,k))
            end
        end
        fprintf([Data.Vallabels{j}{cat} '\n'])
    end
end
if model==2 || model==4
    fprintf('Scaling factors\n');
    fprintf('     ');
    for j=1:m
        fprintf('       Var %i',j);
    end
    fprintf('\n');
    for j=1:m
        fprintf('Var %i',j)
        for k=1:m
            fprintf('    %8.3f',Results.S(j,k));
        end
        fprintf('\n');
    end
elseif model==3
    for dim=1:p
        fprintf('Scaling factors for dimension %i\n',dim);
        fprintf('     ');
        for j=1:m
            fprintf('       Var %i',j);
        end
        fprintf('\n');
        for j=1:m
            fprintf('Var %i',j)
            for k=1:m
                fprintf('    %8.3f',Results.S(j,k,dim));
            end
            fprintf('\n');
        end
    end
elseif model==5
    fprintf('Scaling factors\n');
    fprintf('     ');
    for j=1:p
        fprintf('       Dim %i',j);
    end
    fprintf('\n');
    for j=1:p
        fprintf('Dim %i',j)
        for k=1:p
            fprintf('    %8.3f',Results.S(j,k));
        end
        fprintf('\n');
    end
end